package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;

public class MediationMainActivity extends Activity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.mediation_activity_main);

        TextView tvVersion = findViewById(R.id.tv_version);
        String ver = getString(R.string.main_sdk_version_tip, NGAdManagerHolder.get().getSDKVersion());
        tvVersion.setText(ver);


        findViewById(R.id.btn_main_banner).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MediationMainActivity.this, MediationBannerActivity.class);
                startActivity(intent);
            }
        });
        findViewById(R.id.btn_main_Splash).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MediationMainActivity.this, MediationSplashStartActivity.class);
                startActivity(intent);
            }
        });

        findViewById(R.id.btn_main_Reward).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MediationMainActivity.this, MediationRewardActivity.class);
                startActivity(intent);
            }
        });

        findViewById(R.id.btn_main_full_interaction).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MediationMainActivity.this, MediationInterstitialFullActivity.class);
                startActivity(intent);
            }
        });

    }
}
